/*---------------------------------------------*\
|  Servo Driver					|
|  Contains functions used to drive ATMega328	|
|  Servo Driver and Arduino Vex Robot Controller|
\*---------------------------------------------*/

#include "servo.h"

int serialOpen(string dev)
{
  int fd; //File descriptor for port
  
  fd = open(dev.c_str(), O_RDWR | O_NOCTTY | O_NDELAY);

  if (fd == -1)
  {
    cout << "Unable to open port " << dev << endl;
  }
  else
  {
    fcntl(fd, F_SETFL, 0);
  }
  return fd;
}

void updateServo(char position, int port)
{
  char buffer[3] = {255, position, 200};
  write(port, buffer, 3);
}

void updateVex(char motor1, char motor2, int port)
{
  char buffer[4] = {255, motor1, motor2, 200}; //Update vex command
  write(port, buffer, 4);
}

char* get_speed_limit(int port)
{
  char buffer[4] = {253,0,0,200}; //Request speed limit command
  write(port, buffer, 4);
  char limitstr;
  read(port, &limitstr, 10);
  return &limitstr;
}

void set_speed_limit(char m1, char m2, int port)
{
  char buffer[4] = {254, m1, m2, 200}; //Set speed limit command
  write(port, buffer, 4);
}
